
# Purge Deleted Items
# Copyright 2004 by Alexander V. Christensen
#   Special thanks to Brian Christensen

"""
Completely removes all of those persistent "deleted" items
  (projects, reports, tasks, resources, and so on).  Always backup
  your data before you use a maintenance script.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040714 -- first version
# 040717 -- updated to remove any children of purged records

# Also removes non-deleted instances of:
#   - reports of deleted projects,
#   - report columns of deleted projects,
#   - assignments and dependencies of deleted tasks.
# Thus non-deleted records may disappear during the purge,
#   if they have become meaningless as a result of the purge.
# A future release of GanttPV will delete those records automatically.
#   That will not interfere with this script.
# Does not remove deleted report and column types, because they should
#   not normally be deleted.

# Does not remove deleted report and column types, because they should not normally be deleted.

dlg = wx.MessageDialog(None, 'Purging deleted items is not undo-able!', 'Warning!')

if dlg.ShowModal() == wx.ID_OK:

    # search tables and remove records with the 'deleted' flag.
    for tableName, table in Data.Database.items():
        if tableName in ('Other', 'NextID', 'Prerequisite', 'ReportType', 'ColumnType'):
            continue
        for recordID, record in table.items():
            if record.get('zzStatus') == 'deleted':
                 if tableName == 'Report':
                     Data.CloseReport(recordID)
                 del table[recordID]

    # delete all dependencies not in use
    taskTable = Data.Database['Task']
    dependTable =  Data.Database['Dependency']
    for recordID, record in dependTable.items():
        task = record.get('TaskID')
	prereq = record.get('PrerequisiteID')
        if not taskTable.has_key(task) or not taskTable.has_key(prereq):
            del dependTable[recordID]

    # delete all resources not in use
    assignTable =  Data.Database['Assignment']
    resourceTable = Data.Database['Resource']
    for recordID, record in assignTable.items():
        task = record.get('TaskID')
	resource = record.get('ResourceID')
        if not taskTable.has_key(task) or not resourceTable.has_key(resource):
            del assignTable[recordID]

    # delete all reports not in use
    projectTable = Data.Database['Project']
    reportTable = Data.Database['Report']
    for recordID, record in reportTable.items():
        project = record.get('ProjectID')
        if not projectTable.has_key(project):
            Data.CloseReport(recordID)
            del reportTable[recordID]

    # delete all report columns not in use
    columnTable = Data.Database['ReportColumn']
    for recordID, record in columnTable.items():
        report = record.get('ReportID')
        if not reportTable.has_key(report):
            del columnTable[recordID]

    # mark all report rows as not in use.
    for recordID, record in Data.Database['ReportRow'].items():
        record['zzInUse'] = False

    # make a list of report rows that still in use and re-append them into the database.
    rowTable = Data.Database['ReportRow']
    for reportID, report in Data.Database['Report'].items():
        oldRows = Data.GetRowList(reportID)
        newRows = []
        for rowID in oldRows:
            record = rowTable[rowID]
            ta = record.get('TableName')
            if not ta: continue
            tid = record.get('TableID')
            if Data.Database[ta].has_key(tid):
                newRows.append(rowID)
                record['zzInUse'] = True
        newRows.append(0)
        newID = newRows.pop(0)
        report['FirstRow'] = newID
        while newRows:
            prior = newID
            newID = newRows.pop(0)
            rowTable[prior]['NextRow'] = newID

    # clear the in use flag
    for recordID, record in rowTable.items():
        if record['zzInUse'] == False:
            del rowTable[recordID]
        else:
            del record['zzInUse']

    # update all windows to reflect changes
    Data.UndoStack = []
    Data.RedoStack = []
    Data.ChangedRow = True
    Data.Recalculate()

dlg.Destroy()
